# URLTexter Brand Guidelines for Affiliates

## Brand Overview

URLTexter is an AI-powered text extraction platform that transforms cluttered web content into clean, readable text. Our brand represents efficiency, intelligence, and professional quality.

### Brand Personality
- **Intelligent**: Cutting-edge AI technology
- **Efficient**: Fast, streamlined solutions
- **Professional**: Enterprise-grade quality
- **Accessible**: Easy to use for everyone
- **Trustworthy**: Reliable and accurate results

---

## Logo Usage

### Primary Logo
Use the primary logo with the gradient icon for most applications. This is the preferred version for digital media.

**File:** `urltexter-logo-primary.svg`

### White Logo
Use the white logo on dark backgrounds or when the primary logo doesn't provide sufficient contrast.

**File:** `urltexter-logo-white.svg`

### Icon Only
Use the icon-only version when space is limited or for social media profile images.

**File:** `urltexter-icon-only.svg`

### Logo Clear Space
Maintain clear space around the logo equal to the height of the "URL" text in the logo. This ensures the logo has proper breathing room and maximum impact.

### Minimum Sizes
- **Primary Logo**: Minimum width of 120px digital, 1 inch print
- **Icon Only**: Minimum size of 24px digital, 0.25 inch print

### Logo Don'ts
❌ Don't stretch or distort the logo
❌ Don't change the colors
❌ Don't add effects, shadows, or outlines
❌ Don't place on busy backgrounds without sufficient contrast
❌ Don't recreate or modify the logo
❌ Don't use low-resolution versions

---

## Color Palette

### Primary Colors

**URLTexter Red**
- Hex: `#D73527`
- RGB: `215, 53, 39`
- CMYK: `0, 75, 82, 16`
- Pantone: Red 032 C

**URLTexter Blue**
- Hex: `#4A90E2`
- RGB: `74, 144, 226`
- CMYK: `67, 36, 0, 11`
- Pantone: 285 C

### Secondary Colors

**White**
- Hex: `#FFFFFF`
- RGB: `255, 255, 255`
- Use for backgrounds and contrast

**Light Gray**
- Hex: `#F8F9FA`
- RGB: `248, 249, 250`
- Use for subtle backgrounds

**Medium Gray**
- Hex: `#E9ECEF`
- RGB: `233, 236, 239`
- Use for borders and dividers

**Dark Gray**
- Hex: `#6C757D`
- RGB: `108, 117, 125`
- Use for secondary text

**Black**
- Hex: `#212529`
- RGB: `33, 37, 41`
- Use for primary text

### Accent Colors

**Success Green**
- Hex: `#28A745`
- RGB: `40, 167, 69`
- Use for positive actions and success states

**Warning Orange**
- Hex: `#FFC107`
- RGB: `255, 193, 7`
- Use for warnings and attention

**Commission Gold**
- Hex: `#FFD700`
- RGB: `255, 215, 0`
- Use for affiliate commission highlights

---

## Typography

### Primary Font: Inter
Inter is our primary typeface for all digital applications. It provides excellent readability and a modern, professional appearance.

**Font Weights:**
- Light (300): Use for large headers where elegance is needed
- Regular (400): Use for body text and general content
- Medium (500): Use for subheadings and emphasis
- SemiBold (600): Use for button text and strong emphasis
- Bold (700): Use for headlines and important callouts

**Web Font Import:**
```css
@import url('https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap');
```

### Font Hierarchy

**H1 - Main Headlines**
- Font: Inter Bold (700)
- Size: 32-48px digital
- Color: #212529 or #FFFFFF on dark backgrounds
- Use: Page titles, main headlines

**H2 - Section Headers**
- Font: Inter SemiBold (600)
- Size: 24-32px digital
- Color: #212529 or #333333
- Use: Section titles, major headings

**H3 - Subsection Headers**
- Font: Inter Medium (500)
- Size: 20-24px digital
- Color: #333333 or #212529
- Use: Subsections, feature titles

**Body Text**
- Font: Inter Regular (400)
- Size: 16px digital
- Line Height: 1.6
- Color: #666666 or #212529
- Use: Main content, descriptions

**Small Text**
- Font: Inter Regular (400)
- Size: 14px digital
- Color: #6C757D
- Use: Captions, disclaimers, metadata

### Typography Don'ts
❌ Don't use Comic Sans, Papyrus, or other non-professional fonts
❌ Don't use all caps for long passages
❌ Don't use font sizes smaller than 12px for body text
❌ Don't use more than 3 font weights in a single design
❌ Don't stretch or condense the font

---

## Voice and Tone Guidelines

### Brand Voice
URLTexter speaks with confidence, clarity, and helpfulness. We're the knowledgeable expert who makes complex technology simple and accessible.

**Voice Characteristics:**
- **Professional but approachable**: We're experts, but not intimidating
- **Clear and concise**: We get to the point quickly
- **Helpful and solution-focused**: We solve problems
- **Confident without being arrogant**: We know our stuff but stay humble

### Tone Variations by Context

**Marketing Materials (Energetic & Persuasive)**
- "Transform your workflow in seconds!"
- "Join 50,000+ professionals who've streamlined their research"
- "Stop wasting time on manual content extraction"

**Educational Content (Helpful & Informative)**
- "Here's how URLTexter's AI identifies main content..."
- "Follow these steps to extract clean text from any webpage"
- "This feature helps you process multiple URLs efficiently"

**Support Materials (Patient & Clear)**
- "We're here to help you get the most out of URLTexter"
- "Let's walk through this step by step"
- "This is a common question, and here's how to solve it"

### Words We Use
✅ Transform, streamline, efficient, intelligent, professional
✅ Clean, accurate, instant, seamless, powerful
✅ Save time, increase productivity, eliminate waste
✅ AI-powered, automated, smart, advanced

### Words We Avoid
❌ Revolutionary, disruptive, groundbreaking (overused)
❌ Amazing, incredible, unbelievable (hyperbolic)
❌ Cheap, basic, simple (diminishes our value)
❌ Complex technical jargon without explanation

---

## Visual Style Guidelines

### Photography and Imagery
- Use clean, professional imagery
- Focus on productivity and workflow scenarios
- Show diverse professionals using technology
- Avoid cluttered or busy backgrounds
- Use natural lighting when possible

### Iconography
- Use simple, clean line icons
- Maintain consistent stroke weight (2px)
- Use URLTexter Blue (#4A90E2) for icon colors
- Ensure icons are accessible and universally understood

### Layout and Spacing
- Use generous white space for clarity
- Maintain consistent margins and padding
- Follow the 8px grid system for spacing
- Ensure content hierarchy is clear
- Keep layouts clean and uncluttered

---

## Affiliate Marketing Guidelines

### Commission Disclosure
Always include clear affiliate disclosure when promoting URLTexter:

**Required Disclosure Text:**
"This post contains affiliate links. When you purchase through these links, I earn a commission at no extra cost to you. I only recommend tools I personally use and believe will benefit you."

### Approved Marketing Claims
✅ "Save 10+ hours per week with automated text extraction"
✅ "Join 50,000+ professionals using URLTexter"
✅ "99.9% accuracy rate in text extraction"
✅ "Process any URL in under 3 seconds"
✅ "Earn 30% recurring commissions for 12 months"

### Prohibited Claims
❌ Don't guarantee specific earnings or results
❌ Don't make medical or health claims
❌ Don't use "get rich quick" language
❌ Don't make false or exaggerated claims
❌ Don't imply official partnership unless approved

### Content Guidelines
- Always test the product before promoting it
- Provide honest, balanced reviews
- Include both benefits and limitations
- Use your affiliate link appropriately
- Follow FTC disclosure requirements

---

## Asset Usage Rights

### What You Can Do
✅ Use provided logos and brand assets in promotional materials
✅ Resize logos while maintaining proportions
✅ Use brand colors in your designs
✅ Create original content featuring URLTexter
✅ Share provided marketing materials

### What You Cannot Do
❌ Modify or recreate the URLTexter logo
❌ Use brand assets for competing products
❌ Claim official partnership without approval
❌ Use assets in inappropriate or offensive content
❌ Sell or redistribute brand assets to others

---

## Contact Information

For brand guideline questions or approval requests:
- **Email**: affiliates@urltexter.com
- **Website**: https://affiliates.urltexter.com
- **Response Time**: 2-3 business days

### Brand Asset Requests
If you need additional brand assets or have specific requirements:
1. Email your request to affiliates@urltexter.com
2. Include details about intended usage
3. Provide timeline and specifications
4. Allow 5-7 business days for custom requests

---

## Version History

**Version 1.0** - Initial brand guidelines
**Last Updated**: [CURRENT_DATE]
**Next Review**: [REVIEW_DATE]

---

*These guidelines ensure consistent brand representation across all affiliate marketing materials. Following these standards helps maintain URLTexter's professional image while maximizing the effectiveness of your promotional efforts.*